// PdfOcxDemoDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "PdfOcxDemo.h"
#include "PdfOcxDemoDlg.h"

#include <windowsx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define BOOKMARK_INFO_FILE          _T("BookmarkInfo.xml")

#define ID_TIMER_AUTO_PAGE          1000
#define AUTO_PAGE_INTERVAL          (5 * 1000)  // Զҳʱ䣬5

#define PAGE_TXT_POS_X              280
#define PAGE_TXT_POS_Y              5
#define PAGE_BOX_WIDTH              40
#define PAGE_BOX_HEIGHT             20
#define PAGE_TOTAL_WIDTH            40

// Ӧó򡰹ڡ˵ CAboutDlg Ի

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Ի
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ֧

// ʵ
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// CPdfOcxDemoDlg Ի
CPdfOcxDemoDlg::CPdfOcxDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPdfOcxDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPdfOcxDemoDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_SCROLLBAR, m_ctrlVScrollbar);
    DDX_Control(pDX, IDC_PDF, m_ctrlPdf);
}

BEGIN_MESSAGE_MAP(CPdfOcxDemoDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP

    ON_MESSAGE(WM_AUTOPAGE_INFO, &CPdfOcxDemoDlg::OnAutoPageSetup)

    ON_BN_CLICKED(ID_BN_OPEN, &CPdfOcxDemoDlg::OnClickedOpen)
    ON_BN_CLICKED(ID_BN_CLOSE, &CPdfOcxDemoDlg::OnClickedClose)

    ON_COMMAND(IDM_GOTO_FIRST, &CPdfOcxDemoDlg::OnMenuGotoFirst)
    ON_COMMAND(IDM_GOTO_LAST, &CPdfOcxDemoDlg::OnMenuGotoLast)
    ON_COMMAND(IDM_BOOKMARK_INSERT, &CPdfOcxDemoDlg::OnMenuBookmarkInsert)
    ON_COMMAND(IDM_BOOKMARK_GOTO, &CPdfOcxDemoDlg::OnMenuBookmarkGoto)

    ON_BN_CLICKED(ID_BN_PREVIOUS, &CPdfOcxDemoDlg::OnClickedPrevious)
    ON_BN_CLICKED(ID_BN_NEXT, &CPdfOcxDemoDlg::OnClickedNext)
    ON_BN_CLICKED(ID_BN_SINGLE, &CPdfOcxDemoDlg::OnClickedSingle)
    ON_BN_CLICKED(ID_BN_DOUBLE, &CPdfOcxDemoDlg::OnClickedDouble)
    ON_BN_CLICKED(ID_BN_AUTO_PAGE, &CPdfOcxDemoDlg::OnClickedAutoPage)

    ON_BN_CLICKED(ID_BN_COLOR, &CPdfOcxDemoDlg::OnClickedColor)
    ON_COMMAND(IDM_COLOR_FONT, &CPdfOcxDemoDlg::OnMenuColorFont)
    ON_COMMAND(IDM_COLOR_PAPER, &CPdfOcxDemoDlg::OnMenuColorPaper)
    ON_COMMAND(IDM_COLOR_BACKGROUND, &CPdfOcxDemoDlg::OnMenuColorBackground)
    ON_COMMAND(IDM_COLOR_DEFAULT, &CPdfOcxDemoDlg::OnMenuColorDefault)

    ON_BN_CLICKED(ID_BN_FIND, &CPdfOcxDemoDlg::OnClickedFind)
    ON_BN_CLICKED(ID_BN_FIND_PREV, &CPdfOcxDemoDlg::OnClickedFindPrevious)
    ON_BN_CLICKED(ID_BN_FIND_NEXT, &CPdfOcxDemoDlg::OnClickedFindNext)
    
    ON_WM_CONTEXTMENU()
    ON_WM_TIMER()
    ON_WM_SIZE()
    ON_WM_VSCROLL()
    ON_WM_MOUSEWHEEL()
    ON_WM_DESTROY()
END_MESSAGE_MAP()


// CPdfOcxDemoDlg Ϣ

BOOL CPdfOcxDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ...˵ӵϵͳ˵С

	// IDM_ABOUTBOX ϵͳΧڡ
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	//CMenu* pSysMenu = GetSystemMenu(FALSE);
	//if (pSysMenu != NULL)
	//{
	//	CString strAboutMenu;
	//	strAboutMenu.LoadString(IDS_ABOUTBOX);
	//	if (!strAboutMenu.IsEmpty())
	//	{
	//		pSysMenu->AppendMenu(MF_SEPARATOR);
	//		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	//	}
	//}

	// ô˶ԻͼꡣӦóڲǶԻʱܽԶ
	//  ִд˲
	SetIcon(m_hIcon, TRUE);			// ôͼ
	SetIcon(m_hIcon, FALSE);		// Сͼ

    ShowWindow(SW_MAXIMIZE);        // 󻯴

    /*/
    m_wndToolbar.CreateEx(
                        this, 
                        TBSTYLE_FLAT | WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC, 
                        IDR_TOOLBAR
                        );
    //m_wndToolbar.LoadToolBar(IDR_TOOLBAR);
    m_wndToolbar.Create(this);
    m_wndToolbar.LoadToolBar(IDR_TOOLBAR);
    RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);   //λ
    m_wndToolbar.SetButtonInfo(5, ID_BN_SINGLE, TBBS_CHECKGROUP, 3);
    m_wndToolbar.SetButtonInfo(6, ID_BN_DOUBLE, TBBS_CHECKGROUP, 4);

    CreatePageBox();//*/

    InitXmlAnalyzer();
   
    InitToolbar();

    m_dlgSetInterval.Create(IDD_SET_INTERVAL, this);

    m_ctrlPdf.SetLicenseNum (_T (""));

	return TRUE;  // ǽõؼ򷵻 TRUE
}

void CPdfOcxDemoDlg::InitXmlAnalyzer()
{
    CString strXMLPath;

    GetCurrentDirectory(MAX_PATH, strXMLPath.GetBuffer(MAX_PATH));
    strXMLPath.ReleaseBuffer();

    strXMLPath += _T("\\");
    strXMLPath += BOOKMARK_INFO_FILE;

    m_strXMLPath = strXMLPath;

    // loadʧܣļڣǾԼһ
    if (!m_objXml.Load(m_strXMLPath))
    {
        CString strXML;

        strXML = _T("<?xml version=\"1.0\"?><bookmarklist></bookmarklist>"); 
        m_objXml.SetDoc(strXML);
    }
}

BOOL CPdfOcxDemoDlg::LoadBookmark()
{
    m_objXml.ResetPos();

    if (m_objXml.FindElem(_T("bookmarklist")))
    {
        m_objXml.IntoElem();

        while (m_objXml.FindElem(_T("info")))
        {
            if (m_objXml.FindChildElem(_T("uri")))
            {
                CString strURI;

                strURI = m_objXml.GetChildData();
                if (m_strURI == strURI)
                {
                    if (m_objXml.FindChildElem(_T("page")))
                    {
                        m_strBookmarkPage = m_objXml.GetChildData();

                        return TRUE;
                    }
                }
            }
        }
    }

    m_strBookmarkPage.Empty();

    return FALSE;
}

void CPdfOcxDemoDlg::InitToolbar()
{
    m_wndToolbar.Create(this);
    m_wndToolbar.LoadToolBar(IDR_TOOLBAR);
    RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, 0);   //λ

    CreateDisplayModeBox();

    CreatePageBox();

    CreateFindBox();
}

void CPdfOcxDemoDlg::CreateDisplayModeBox()
{
    RECT  rc;
    HFONT fnt = NULL;

    fnt = (HFONT)GetStockObject(DEFAULT_GUI_FONT);  // TODO: this might not work on win95/98

    m_wndToolbar.GetItemRect(6, &rc);
    m_bnSingle.Create(_T("ҳ"), BS_AUTORADIOBUTTON | BS_TEXT | WS_VISIBLE, rc, &m_wndToolbar, ID_BN_SINGLE);
    SetWindowFont(m_bnSingle.m_hWnd, fnt, TRUE);

    m_wndToolbar.GetItemRect(7, &rc);
    m_bnDouble.Create(_T("˫ҳ"), BS_AUTORADIOBUTTON | BS_TEXT | WS_VISIBLE, rc, &m_wndToolbar , ID_BN_DOUBLE);
    SetWindowFont(m_bnDouble.m_hWnd, fnt, TRUE);
    m_bnDouble.SetCheck(BST_CHECKED);
}

void CPdfOcxDemoDlg::CreatePageBox()
{
    RECT    rc;
    HFONT   fnt = NULL;

    fnt = (HFONT)GetStockObject(DEFAULT_GUI_FONT); 

    m_wndToolbar.GetItemRect(10, &rc);
    m_ctrlPage.Create(
                    WS_VISIBLE | WS_CHILD | ES_MULTILINE | ES_AUTOHSCROLL | ES_NUMBER | ES_RIGHT, 
                    rc, 
                    &m_wndToolbar, 
                    ID_EDIT_PAGE
                    );
    SetWindowFont(m_ctrlPage.m_hWnd, fnt, TRUE);
    m_ctrlPage.SetWindowText(_T("0"));

    m_wndToolbar.GetItemRect(11, &rc);
    m_ctrlPageCount.Create(_T("/ 0"), WS_VISIBLE | WS_CHILD, rc, &m_wndToolbar, ID_PAGE_COUNT);
    SetWindowFont(m_ctrlPageCount, fnt, TRUE);
}

void CPdfOcxDemoDlg::UpdateUI()
{
    UpdatePageBox();

    UpdateScrollbar();
}

void CPdfOcxDemoDlg::UpdatePageBox()
{
    UINT uiCurPage = 0;
    UINT uiPageCount = 0;

    uiCurPage = m_ctrlPdf.GetCurrentPage();
    uiPageCount = m_ctrlPdf.GetPageCount();
    if (uiPageCount > 0)
    {
        CString strCurPage;
        CString strPageCount;

        strCurPage.Format(_T("%d"), uiCurPage);
        m_ctrlPage.SetWindowText(strCurPage);

        strPageCount.Format(_T(" / %d"), uiPageCount);
        m_ctrlPageCount.SetWindowText(strPageCount);
    }
    else
    {
        m_ctrlPage.SetWindowText(_T("0"));
        m_ctrlPageCount.SetWindowText(_T(" / 0"));
    }
}

void CPdfOcxDemoDlg::UpdateScrollbar()
{
    UINT uiPageCount = 0;
    UINT uiCurPage = 0;

    uiPageCount = m_ctrlPdf.GetPageCount();
    uiCurPage = m_ctrlPdf.GetCurrentPage();

    if (uiPageCount > 0)
    {
        m_ctrlVScrollbar.EnableWindow(TRUE);

        m_ctrlVScrollbar.SetScrollRange(1, uiPageCount);
        m_ctrlVScrollbar.SetScrollPos(uiCurPage);
    }
    else
    {
        m_ctrlVScrollbar.EnableWindow(FALSE);
    }
}

// Find Button:15 FindText:16 FindPrev:17 FindNext:18
void CPdfOcxDemoDlg::CreateFindBox()
{
    RECT    rc;
    HFONT   fnt = NULL;

    fnt = (HFONT)GetStockObject(DEFAULT_GUI_FONT);

    //m_wndToolbar.SetButtonInfo(15, ID_FIND_LABEL, TBBS_CHECKGROUP, -1);

    m_wndToolbar.GetItemRect(16, &rc);
    m_ctrlFind.Create(
                    WS_VISIBLE | WS_CHILD | ES_MULTILINE | ES_AUTOHSCROLL, 
                    rc, 
                    &m_wndToolbar, 
                    ID_EDIT_FIND
                    );
    SetWindowFont(m_ctrlFind.m_hWnd, fnt, TRUE);

    m_wndToolbar.GetItemRect(17, &rc);
    m_bnFindPrev.Create(_T("<-"), BS_TEXT | WS_VISIBLE, rc, &m_wndToolbar, ID_BN_FIND_PREV);
    SetWindowFont(m_bnFindPrev.m_hWnd, fnt, TRUE);

    m_wndToolbar.GetItemRect(18, &rc);
    m_bnFindNext.Create(_T("->"), BS_TEXT | WS_VISIBLE, rc, &m_wndToolbar, ID_BN_FIND_NEXT);
    SetWindowFont(m_bnFindNext.m_hWnd, fnt, TRUE);
}

void CPdfOcxDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// ԻСťҪĴ
//  Ƹͼꡣʹĵ/ͼģ͵ MFC Ӧó
//  ⽫ɿԶɡ

void CPdfOcxDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ڻƵ豸

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// ʹͼڹо
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ͼ
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//û϶Сʱϵͳô˺ȡùʾ
//
HCURSOR CPdfOcxDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

LRESULT CPdfOcxDemoDlg::OnAutoPageSetup(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
    KillTimer(ID_TIMER_AUTO_PAGE);

    if (m_dlgSetInterval.IsSetup())
    {
        int iInterval = 0;
        iInterval = m_dlgSetInterval.GetInterval();
        SetTimer(ID_TIMER_AUTO_PAGE, iInterval * 1000, NULL);
    }

    return S_OK;
}

void CPdfOcxDemoDlg::OnClickedOpen()
{
    CFileDialog dlgFile(TRUE);
    CString strFilter;
    CString strFileName;

    strFilter = _T("Adobe PDF ļ (*.pdf)");
    strFilter += (TCHAR)'\0';
    strFilter += _T("*.pdf");
    strFilter += (TCHAR)'\0';
    dlgFile.m_ofn.nMaxCustFilter++;

    dlgFile.m_ofn.lpstrFilter = strFilter;
    dlgFile.m_ofn.lpstrTitle = _T(" Adobe PDF ļ");
    dlgFile.m_ofn.lpstrFile = strFileName.GetBuffer(MAX_PATH);

    if (dlgFile.DoModal() == IDOK)
    {
        m_strURI = strFileName;
        m_ctrlPdf.OpenPDF(m_strURI);
        m_ctrlPdf.SetDisplayMode(m_bnSingle.GetCheck());

        UpdateUI();

        LoadBookmark();
    }

    strFileName.ReleaseBuffer();
}

void CPdfOcxDemoDlg::OnClickedClose()
{
    m_ctrlPdf.ClosePDF();

    m_strBookmarkPage.Empty();

    UpdateUI();
}

void CPdfOcxDemoDlg::OnMenuGotoFirst()
{
    m_ctrlPdf.GotoFirstPage();

    UpdateUI();
}

void CPdfOcxDemoDlg::OnMenuGotoLast()
{
    m_ctrlPdf.GotoLastPage();

    UpdateUI();
}

void CPdfOcxDemoDlg::OnClickedPrevious()
{
    m_ctrlPdf.GotoPreviousPage();

    UpdateUI();
}

void CPdfOcxDemoDlg::OnClickedNext()
{
    m_ctrlPdf.GotoNextPage();

    UpdateUI();
}

void CPdfOcxDemoDlg::OnClickedSingle()
{
    m_ctrlPdf.SetDisplayMode(TRUE);

    UpdateUI();
}

void CPdfOcxDemoDlg::OnClickedDouble()
{
    m_ctrlPdf.SetDisplayMode(FALSE);

    UpdateUI();
}

void CPdfOcxDemoDlg::OnClickedAutoPage()
{
    if (::IsWindow(m_dlgSetInterval.m_hWnd))
    {
        RECT rcBN = {0};
        RECT rc = {0};

        m_wndToolbar.GetItemRect(8, &rcBN);
        m_wndToolbar.ClientToScreen(&rcBN);

        m_dlgSetInterval.GetWindowRect(&rc);
        m_dlgSetInterval.MoveWindow(rcBN.left, rcBN.bottom, rc.right - rc.left, rc.bottom - rc.top);
        m_dlgSetInterval.ShowWindow(SW_SHOW);	
    }
}

void CPdfOcxDemoDlg::OnMenuBookmarkInsert()
{
    int iPage = 0;

    iPage = m_ctrlPdf.GetCurrentPage();
    if (iPage > 0)
    {
        m_strBookmarkPage.Format(_T("%d"), iPage);

        m_objXml.ResetPos();
        if (m_objXml.FindElem(_T("bookmarklist")))
        {
            BOOL bFind = FALSE;
            m_objXml.IntoElem();

            while (m_objXml.FindElem(_T("info")))
            {
                if (m_objXml.FindChildElem(_T("uri")))
                {
                    CString strURI;

                    strURI = m_objXml.GetChildData();
                    if (m_strURI == strURI)
                    {
                        if (m_objXml.FindChildElem(_T("page")))
                        {
                            m_objXml.SetChildData(m_strBookmarkPage);
                            bFind = TRUE;

                            break;
                        }                        
                    }
                }
            }

            if (!bFind)
            {
                m_objXml.ResetPos();

                if (m_objXml.FindElem(_T("bookmarklist")))
                {
                    CString strXML;

                    m_objXml.IntoElem();

                    // <info><uri>%uri%</uri><page>%page%</page></info>
                    strXML = _T("<info><uri>");
                    strXML += m_strURI;
                    strXML += _T("</uri><page>");
                    strXML += m_strBookmarkPage;
                    strXML += _T("</page></info>");
                    m_objXml.InsertSubDoc(strXML);
                }
            }
        }

    }

    // ʹCMarkupsave⣬ļANSIʽģҪUNICODEʽ
    //m_objXml.Save(m_strXMLPath);
    CFile xmlFile(m_strXMLPath, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary);
    m_objXml.ResetPos();
    CString strXmlDoc = m_objXml.GetDoc();
    WORD   wSignature   =   0xFEFF; // ӦUNICODEļļͷϢ
    xmlFile.Write(&wSignature, 2);
    xmlFile.Write(strXmlDoc, strXmlDoc.GetLength() * sizeof(TCHAR));
}

void CPdfOcxDemoDlg::OnMenuBookmarkGoto()
{
    if (!m_strBookmarkPage.IsEmpty())
    {
        UINT uiPage = 0;

        uiPage = _ttoi(m_strBookmarkPage);
        m_ctrlPdf.GotoThisPage(uiPage);

        UpdateUI();
    }
}

void CPdfOcxDemoDlg::OnClickedColor()
{
    RECT    rc  = {0};
    CMenu   menu;
    CMenu * pSubMenu;

    m_wndToolbar.GetItemRect(13, &rc);
    m_wndToolbar.ClientToScreen(&rc);

    menu.LoadMenu(IDR_MENU_COLOR);
    pSubMenu = menu.GetSubMenu(0);
    if (pSubMenu != NULL)
    {
        pSubMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON, rc.left, rc.bottom, this);
    }
}

void CPdfOcxDemoDlg::OnMenuColorFont()
{
    //MessageBox(_T("ɫ ܻδʵ"), _T("δʵ"), MB_OK);
}

void CPdfOcxDemoDlg::OnMenuColorPaper()
{
    CColorDialog dlgColor;

    if (dlgColor.DoModal() == IDOK)
    {
        COLORREF color = dlgColor.GetColor();

        m_ctrlPdf.SetPaperColor(color);
    }
}

void CPdfOcxDemoDlg::OnMenuColorBackground()
{
   CColorDialog dlgColor;

   if (dlgColor.DoModal() == IDOK)
   {
       COLORREF color = dlgColor.GetColor();

       m_ctrlPdf.SetBackgroundColor(color);
   }
}

void CPdfOcxDemoDlg::OnMenuColorDefault()
{
    m_ctrlPdf.ResetColor();
}

void CPdfOcxDemoDlg::OnClickedFind()
{
    CString strKeyword;

    m_ctrlFind.GetWindowText(strKeyword);
    if (!strKeyword.IsEmpty())
    {
        if (m_strLastKeyword != strKeyword)
        {
            m_ctrlPdf.Find(strKeyword);
            m_strLastKeyword = strKeyword;
        }
        else
        {
            m_ctrlPdf.Find(NULL);
        }

        // TODO: ʾ
    }
}

void CPdfOcxDemoDlg::OnClickedFindPrevious()
{
    m_ctrlPdf.FindPrevious();

    UpdateUI();
    // TODO: ʾ
}

void CPdfOcxDemoDlg::OnClickedFindNext()
{
    m_ctrlPdf.FindNext();

    UpdateUI();
    // TODO: ʾ
}

void CPdfOcxDemoDlg::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
    CMenu menu;
    CMenu * pSubMenu;

    menu.LoadMenu(IDR_MENU_BOOKMARK);
    pSubMenu = menu.GetSubMenu(0);
    if (pSubMenu != NULL)
    {
        if (m_strBookmarkPage.IsEmpty())
        {
            pSubMenu->EnableMenuItem(IDM_BOOKMARK_GOTO, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
        }
        pSubMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON, point.x, point.y, this);
    }
}

BOOL CPdfOcxDemoDlg::PreTranslateMessage(MSG* pMsg)
{
    if (pMsg->message == WM_KEYDOWN)
    {
        if (pMsg->wParam == VK_RETURN)
        {
            if (pMsg->hwnd == m_ctrlPage.m_hWnd)
            {
                CString strPage;
                UINT uiPage = 0;

                m_ctrlPage.GetWindowText(strPage);
                uiPage = _ttoi(strPage);
                m_ctrlPdf.GotoThisPage(uiPage);

                //UpdateUI();

                return TRUE;
            }
            else if (pMsg->hwnd == m_ctrlFind.m_hWnd)
            {
                CString strKeyword;

                m_ctrlFind.GetWindowText(strKeyword);
                if (!strKeyword.IsEmpty())
                {
                    if (m_strLastKeyword != strKeyword)
                    {
                        m_ctrlPdf.Find(strKeyword);
                        m_strLastKeyword = strKeyword;
                    }
                    else
                    {
                        m_ctrlPdf.Find(NULL);
                    }

                    UpdateUI();
                }

                // TODO: ʾ

                return TRUE;
            }
        }

        switch (pMsg->wParam)
        {
        case VK_LEFT:
        case VK_UP:
            {
                m_ctrlPdf.GotoPreviousPage();
                UpdateUI();

                return TRUE;
            }
            break;

        case VK_RIGHT:
        case VK_DOWN:
            {
                m_ctrlPdf.GotoNextPage();
                UpdateUI();

                return TRUE;
            }
            break;

        default:
            {
                //
            }
        }
    }
    else if (pMsg->message == WM_LBUTTONDOWN)
    {
        //if (m_bnDouble.GetCheck() == BST_CHECKED)
        //{
        RECT    rc          = {0};
        RECT    rcClient    = {0};
        POINT   pt          = {0};

        pt.x = LOWORD(pMsg->lParam);
        pt.y = HIWORD(pMsg->lParam);
        ::ClientToScreen(pMsg->hwnd, &pt);

        m_ctrlPdf.GetWindowRect(&rc);
        m_ctrlPdf.GetClientRect(&rcClient);

        if (PtInRect(&rc, pt))
        {
            if (m_bnDouble.GetCheck() == BST_CHECKED)
            {
                if (IsPtInLeftRect(&rcClient, LOWORD(pMsg->lParam)))
                {
                    m_ctrlPdf.GotoPreviousPage();
                }
                else
                {
                    m_ctrlPdf.GotoNextPage();
                }
            }
            else
            {
                m_ctrlPdf.GotoNextPage();
            }

            UpdateUI();
        }
        //}
    }

    return CDialog::PreTranslateMessage(pMsg);
}

BOOL CPdfOcxDemoDlg::IsPtInLeftRect(RECT * lprc, WORD x)
{
    return (x < (lprc->right / 2));
}

void CPdfOcxDemoDlg::OnTimer(UINT_PTR nIDEvent)
{
    if (nIDEvent == ID_TIMER_AUTO_PAGE)
    {
        m_ctrlPdf.GotoNextPage();

        UpdateUI();
    }

    CDialog::OnTimer(nIDEvent);
}

void CPdfOcxDemoDlg::OnSize(UINT nType, int cx, int cy)
{
    CDialog::OnSize(nType, cx, cy);

    int iVScrollbarWidth = 0;

    iVScrollbarWidth = ::GetSystemMetrics(SM_CXVSCROLL);

    if (::IsWindow(m_ctrlPdf.m_hWnd))
    {
        m_ctrlPdf.MoveWindow(0, 30, cx - iVScrollbarWidth, cy - 30, TRUE);
    }

    if (::IsWindow(m_ctrlVScrollbar.m_hWnd))
    {
        m_ctrlVScrollbar.MoveWindow(cx - iVScrollbarWidth, 30, iVScrollbarWidth, cy - 30, TRUE);
    }
}

void CPdfOcxDemoDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    switch (nSBCode)
    {
    case SB_TOP:
        {
            m_ctrlPdf.GotoFirstPage();
            UpdateUI();
        }
        break;

    case SB_BOTTOM:
        {
            m_ctrlPdf.GotoLastPage();
            UpdateUI();
        }
        break;

    case SB_LINEUP:
    case SB_PAGEUP:
        {
            m_ctrlPdf.GotoPreviousPage();
            UpdateUI();
        }
        break;

    case SB_LINEDOWN:
    case SB_PAGEDOWN:
        {
            m_ctrlPdf.GotoNextPage();
            UpdateUI();
        }
        break;

    case SB_THUMBPOSITION:
        {
            m_ctrlPdf.GotoThisPage(nPos);
            UpdateUI();
        }
        break;

    default:
        {
            // do nothing
        }
    }

    CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

BOOL CPdfOcxDemoDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
     if (zDelta > 0)
     {
         m_ctrlPdf.GotoPreviousPage();
     }
     else
     {
         m_ctrlPdf.GotoNextPage();
     }

     UpdateUI();

    return CDialog::OnMouseWheel(nFlags, zDelta, pt);
}

void CPdfOcxDemoDlg::OnDestroy()
{
    CDialog::OnDestroy();

    if (::IsWindow(m_dlgSetInterval.m_hWnd))
    {
        m_dlgSetInterval.DestroyWindow();
    }
}
